/**
* \file: InputChannel.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* Sample input channel implementation for touch
*
* \component: Baidu CarLife
*
* \author: P. Acar / ADIT/ESM / pacar@de.adit-jv.com
*
* \copyright (c) 2017 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef BDCL_INPUTCHANNEL_H
#define BDCL_INPUTCHANNEL_H

#include <bdcl/AditInputSource.h>

namespace adit { namespace bdcl {

class InputChannel : public IAditInputSourceCallbacks
{
public:
    InputChannel(CoreCallbackDealer* inCallbackDealer);
    virtual ~InputChannel();

private:
    AditInputSource* mInputSource;

    /** @brief Callback initiated by ADIT to inform MC application about an error.
     */
    void onError(bdclErrorCodes inErrorCode);
};

} } /* namespace adit { namespace bdcl { */

#endif /* BDCL_INPUTCHANNEL_H */
